
$FullscreenMode = true;
$ScreenResolution = "800 600 32";
$LastResolution = "800 600 32";
$ScreenDepth = 32;
$GammaCorrection = 0.5;
$MusicVolume = 0.5;
$SFXVolume = 0.5;
$HatDetailLevel = $Detail::Medium;
$HatEnabled = true;
$ZoomDetailLevel = $Detail::Medium;
$ZoomLevelEnabled = true;
$ZoomLevelPos = 2;

$ResolutionTextHeight = "600 768";
$ResolutionChangeFunction = "TextSmall TextMedium TextLarge";

// text change functions example: x <= 800
function TextSmall()
{
   NashvilleLargeProfile.dynamicTextSize(24);
   WestwardDialogsmProfile.dynamicTextSize(17);
   WestwardDialogProfile.dynamicTextSize(19);
   
   WestwardHudMessageProfile.dynamicTextSize(18);
   WestwardcenterProfile.dynamicTextSize(20);
   WestwardcentersmProfile.dynamicTextSize(19);
   
   WestwardRightProfile.dynamicTextSize(22);
   WestwardLeftProfile.dynamicTextSize(22);
   
   WestwardLargeProfile.dynamicTextSize(22);
   XPtabButtonProfile.dynamicTextSize(39);
   WWLargeCenterProfile.dynamicTextSize(32);
}

// text change functions example: 800 < x <= 1024
function TextMedium()
{
   NashvilleLargeProfile.dynamicTextSize(30);
   WestwardDialogsmProfile.dynamicTextSize(20);
   WestwardHudMessageProfile.dynamicTextSize(20);
   WestwardcenterProfile.dynamicTextSize(24);
   WestwardcentersmProfile.dynamicTextSize(22);
   WestwardRightProfile.dynamicTextSize(26);
   WestwardLeftProfile.dynamicTextSize(26);
   WestwardDialogProfile.dynamicTextSize(22);
   WestwardLargeProfile.dynamicTextSize(26);
   XPtabButtonProfile.dynamicTextSize(44);
   WWLargeCenterProfile.dynamicTextSize(37);
}

// text change functions example: 1024 < x
function TextLarge()
{
   NashvilleLargeProfile.dynamicTextSize(30);
   WestwardDialogsmProfile.dynamicTextSize(20);
   WestwardHudMessageProfile.dynamicTextSize(20);
   WestwardcenterProfile.dynamicTextSize(24);
   WestwardcentersmProfile.dynamicTextSize(22);
   WestwardRightProfile.dynamicTextSize(26);
   WestwardLeftProfile.dynamicTextSize(26);
   WestwardDialogProfile.dynamicTextSize(22);
   WestwardLargeProfile.dynamicTextSize(26);
   XPtabButtonProfile.dynamicTextSize(44);
   WWLargeCenterProfile.dynamicTextSize(37);
}

// this function is used to determine which text resizing function
// should be called (which will update the text sizes)
function ProcessResolutionChange(%height)
{
   %heightIndex = 0;
   %heightCount = getWordCount($ResolutionTextHeight);
   while (%heightIndex < %heightCount &&
      %height > getWord($ResolutionTextHeight, %heightIndex))
   {
      %heightIndex++;
   }
   
   %function = getWord($ResolutionChangeFunction, %heightIndex);
   call(%function);
}

// when the game first starts up, start it with the proper text size
ProcessResolutionChange(getWord($pref::Video::resolution, 1));
QuestResolutionChange(getWord($pref::Video::resolution, 0),
   getWord($pref::Video::resolution, 1));

// this is called when the options should be saved out
function GameOptionsGui::saveOptions(%dialog)
{
   Canvas.popDialog(GameOptionsGui);
}

// when the resolution list needs to be loaded to the menu selection
function GameOptionsResolutionMenu::loadOptions(%menu)
{
   GameOptionsResolutionMenu.clear();
   
   %desktopWidth = getWord($FirstDesktopDim, 0);
   %desktopHeight = getWord($FirstDesktopDim, 1);
   
   $resolutionList16Count = 0;
   $resolutionList32Count = 0;
   
   $ScreenResolution = getRes();
   if ($FullscreenMode == false)
   {
      $LastResolution = $ScreenResolution;
   }
   
   %resolutionWidth = getWord($ScreenResolution, 0);
   %resolutionHeight = getWord($ScreenResolution, 1);

   // update the windowed button disabled state
   WindowedButton.disabled = ($FullscreenMode == true &&
      getWord($FirstDesktopDim, 0) == 800 &&
      getWord($FirstDesktopDim, 1) == 600);
   
   // get the resolution list and split it into two separate lists
   // based on the bit depth of the screen (32 or 16 bit modes)
   %fullResolutionList = getResolutionList("D3D");
   %fullResolutionCount = getFieldCount(%fullResolutionList);
   for (%index = 0; %index < %fullResolutionCount; %index++)
   {
      %resolution = getField(%fullResolutionList, %index);
      %width = getWord(%resolution, 0);
      %height = getWord(%resolution, 1);
      %depth = getWord(%resolution, 2);
      
      if ($FullscreenMode == false)
      {
         // the resolution must be larger than 800x600
         if (%width < %desktopWidth && %height < %desktopHeight)
         {
            // these are the resolutions supported in the game
            if (%width == 800 && %height == 600 ||
               %width == 1024 && %height == 768 ||
               %width == 1280 && %height == 768 ||
               %width == 1280 && %height == 800)
            {
            
               // if this is a 32-bit mode, add it to the 32-bit list
               if (%depth == 32)
               {
                  $resolutionList32[$resolutionList32Count] = %resolution;
                  $resolutionList32Count++;
               }
               // if this is a 16-bit mode, add it to the 16-bit list
               else if (%depth == 16)
               {
                  $resolutionList16[$resolutionList16Count] = %resolution;
                  $resolutionList16Count++;
               }
            }
         }
      }
      else
      {
         // these are the resolutions supported in the game
         if (%width == 800 && %height == 600 ||
            %width == 1024 && %height == 768 ||
            %width == 1280 && %height == 768 ||
            %width == 1280 && %height == 800)
         {
            // if this is a 32-bit mode, add it to the 32-bit list
            if (%depth == 32)
            {
               $resolutionList32[$resolutionList32Count] = %resolution;
               $resolutionList32Count++;
            }
            // if this is a 16-bit mode, add it to the 16-bit list
            else if (%depth == 16)
            {
               $resolutionList16[$resolutionList16Count] = %resolution;
               $resolutionList16Count++;
            }
         }
      }
   }
   
   // if there are 32-bit options, add all of the 32-bit options
   // to the resolution list
   if ($resolutionList32Count > 0)
   {
      $ScreenDepth = 32;
      for (%index = 0; %index < $resolutionList32Count; %index++)
      {
         %resolution = $resolutionList32[%index];
         %width = getWord(%resolution, 0);
         %height = getWord(%resolution, 1);
         
         if (%width != %resolutionWidth || %height != %resolutionHeight)
         {
            GameOptionsResolutionMenu.add(%width @ " x " @ %height, %index);
         }
      }
   }
   // if there are no 32-bit options, but there are 16bit options,
   // add all of the 16-bit options to the resolution list
   else if ($resolutionList16Count > 0)
   {
      $ScreenDepth = 16;
      for (%index = 0; %index < $resolutionList16Count; %index++)
      {
         %resolution = $resolutionList16[%index];
         %width = getWord(%resolution, 0);
         %height = getWord(%resolution, 1);
         
         if (%width != %resolutionWidth || %height != %resolutionHeight)
         {
            GameOptionsResolutionMenu.add(%width @ " x " @ %height, %index);
         }
      }
   }
   // this should never happen; in the event that there is no
   // resolution available, we will print an error
   else
   {
      echo("This should never happen at this point.  The game started in a strange mode.");
   }

   // set the current resolution as the selected resolution
   GameOptionsResolutionMenu.setText(getWord($ScreenResolution, 0) @
      " x " @ getWord($ScreenResolution, 1));
      
   //%menu.visible = !$FullscreenMode;
   updateHats();
   updateZoomLevel();
}

// when a resolution has been selected from the resolution list
function GameOptionsResolutionMenu::onSelect(%menu, %id, %text)
{
   // get the new resolution that was selected
   if ($ScreenDepth == 32)
   {
      %newResolution = $resolutionList32[%id];
   }
   else
   {
      %newResolution = $resolutionList16[%id];
   }
   
   // if the same screen resolution is selected, do nothing
   if ($ScreenResolution $= %newResolution)
   {
      return;
   }
   
   // change the screen resolution based on the new settings
   $ScreenResolution = %newResolution;
   if ($FullscreenMode == false)
   {
      $LastResolution = %newResolution;
   }
   %width = getWord($ScreenResolution, 0);
   %height = getWord($ScreenResolution, 1);
   %depth = getWord($ScreenResolution, 2);
   
   QuestResolutionChange(%width, %height);

   // update the resolution that was selected
   ProcessResolutionChange(%height);
   setRes(%width, %height, %depth);
   %menu.loadOptions();
}

// this updates the gamma correction for the game
function GameOptionsGammaCorrection::loadOptions()
{
   $GammaCorrection = GameOptionsGammaCorrection.value;
   //videoSetGammaCorrection($GammaCorrection);
   $pref::OpenGL::gammaCorrection = $GammaCorrection;
}

// this function is called when the gamma correction changes on mouse down
function GameOptionsGammaCorrection::onMouseDown(%slider)
{
   %slider.loadOptions();
}

// this function is called when the gamma correction changes on mouse dragged
function GameOptionsGammaCorrection::onMouseDragged(%slider)
{
   %slider.loadOptions();
}

// this function is called when the music volume changes
function GameOptionsMusic::loadOptions()
{
   //$pref::Audio::masterVolume
   $MusicVolume = GameOptionsMusic.value;
   alxSetChannelVolume($AudioChannel1, $MusicVolume);
   $pref::Audio::channelVolume1 = $MusicVolume;
}

// this function is called when the music volume changes on mouse down
function GameOptionsMusic::onMouseDown(%slider)
{
   %slider.loadOptions();
}

// this function is called when the music volume changes on mouse dragged
function GameOptionsMusic::onMouseDragged(%slider)
{
   %slider.loadOptions();
}

// this function is called when the sound effects volume changes
function GameOptionsSFX::loadOptions()
{
   $SFXVolume = GameOptionsSFX.value;
   
   // set slider sound effect
   alxSetChannelVolume($UIAudioType, $SFXVolume);
   
   // save sound effect volume for channels
   for (%channel = $AudioChannel2; %channel <= 8; %channel++)
   {
      if (!$PlayingGame)
      {
         alxSetChannelVolume(%channel, $SFXVolume);
      }
      $pref::Audio::channelVolume[%channel] = $SFXVolume;
   }
}

// this function is called when the sound effects volume changes on mouse down
function GameOptionsSFX::onMouseDown(%slider)
{
   %slider.loadOptions();
}

// this function si called when the sound effects volume changes on mouse dragged
function GameOptionsSFX::onMouseDragged(%slider)
{
   %slider.loadOptions();
}

// when the game should switch to fullscreen mode
function FullscreenButton::buttonSelect()
{
   $FirstDesktopDim = getDesktopResolution();
   
   FullscreenButton.selected = true;
   WindowedButton.selected = false;

   %resolution = $ScreenResolution;
   %width = getWord(%resolution, 0);
   %height = getWord(%resolution, 1);
   %bpp = getWord(%resolution, 2);

   //GameOptionsResolutionMenu.clear();   
   //GameOptionsResolutionMenu.setText(%width @ " x " @ %height);
   //GameOptionsResolutionMenu.add(%width @ " x " @ %height, 100);
   
   // switch to fullscreen mode
   ProcessResolutionChange(%height);
   setScreenMode(%width, %height, %bpp, true);
   $FullscreenMode = true;
   $ScreenResolution = %width @ " " @ %height @ " " @ %bpp;
   GameOptionsResolutionMenu.loadOptions();
   
   //GameOptionsResolutionMenu.visible = false;
}

// when the game should switch to windowed mode
function WindowedButton::buttonSelect()
{
   FullscreenButton.selected = false;
   WindowedButton.selected = true;
   
   // find the resolution that should be used based on
   // the current resolution used and the desktop dimension
   %desktopWidth = getWord($FirstDesktopDim, 0);
   %desktopHeight = getWord($FirstDesktopDim, 1);
   %screenWidth = getWord($ScreenResolution, 0);
   %screenHeight = getWord($ScreenResolution, 1);
   if (%desktopWidth > 1280 && %screenWidth >= 1280)
   {
      if (%desktopHeight > 800 && %screenHeight >= 800) %resolution = "1280 800";
      else if (%desktopHeight > 768 && %screenHeight >= 768) %resolution = "1280 768";
      else %resolution = "800 600";
   }
   else if (%desktopWidth > 1024 && %screenWidth >= 1024)
   {
      if (%desktopHeight > 768 && %screenHeight >= 768) %resolution = "1024 768";
      else %resolution = "800 600";
   }
   else %resolution = "800 600";

   %width = getWord(%resolution, 0);
   %height = getWord(%resolution, 1);
   %bpp = getWord($LastResolution, 2);
   
   // switch to windowed mode
   ProcessResolutionChange(%height);
   setScreenMode(%width, %height, %bpp, false);
   $FullscreenMode = false;
   $ScreenResolution = %width @ " " @ %height @ " " @ %bpp;
   GameOptionsResolutionMenu.loadOptions();
}

function updateShadows()
{
   $pref::Shadows::Available =
      ($pref::LevelOfDetail >= $pref::Shadows::Detail);
}

function updateZoomLevel()
{
   if ($pref::LevelOfDetail < $ZoomDetailLevel && $ZoomLevelEnabled == true)
   {
      $ZoomLevelEnabled = false;
      
      if (isObject($serverCamera) == false)
      {
         return;
      }
      
      %component = $serverCamera.getCameraCmp();
      if (isObject(%component) == false)
      {
         return;
      }
      
      %position = %component.getZoomPos();
      if (%position > $ZoomLevelPos)
      {
         %component.setZoomPos($ZoomLevelPos);
      }
   }
   
   if ($pref::LevelOfDetail >= $ZoomDetailLevel && $ZoomLevelEnabled == false)
   {
      $ZoomLevelEnabled = true;
   }
}

function updateHats()
{
   // check if hats should be removed
   if ($pref::LevelOfDetail < $HatDetailLevel && $HatEnabled == true)
   {
      $HatEnabled = false;
      
      // remove any hats that characters may have on right now
      %list = slgGetServerCharacterList();
      for (%index = 0; %index < %list.getSize(); %index++)
      {
         %object = %list.getId(%index);
         if (%object.removeHat == true)
         {
            %object.unmountImage(0);
         }
      }
      return;
   }
   
   // check if hats should be added
   if ($pref::LevelOfDetail >= $HatDetailLevel && $HatEnabled == false)
   {
      $HatEnabled = true;
      
      // add any hats that characters should have on right now
      %list = slgGetServerCharacterList();
      %count = %list.getSize();
      for (%index = 0; %index < %count; %index++)
      {
         %object = %list.getId(%index);
         RestoreObjectHats(%object);
      }
      return;
   }
}

function updateBuildingProps()
{
   // update the props for each of the buildings
   %list = slgGetServerBuildingList();
   for (%index = 0; %index < %list.getSize(); %index++)
   {
      %object = %list.getId(%index);
      %building = slgQueryInterface(%object, $CID_BUILDING);
      if (isObject(%building) == false)
      {
         continue;
      }
      
      %building.updateProps($pref::LevelOfDetail);
   }
}

// when the low effects detail button is selected
function LowDetailButton::buttonSelect()
{
   LowDetailButton.selected = true;
   MediumDetailButton.selected = false;
   HighDetailButton.selected = false;

   setDetailLevel($Detail::Low);
   $pref::LevelOfDetail = $Detail::Low;
   updateShadows();
   updateHats();
   updateZoomLevel();
   updateBuildingProps();
}

// when the medium effects detail button is selected
function MediumDetailButton::buttonSelect()
{
   LowDetailButton.selected = false;
   MediumDetailButton.selected = true;
   HighDetailButton.selected = false;
   
   setDetailLevel($Detail::Medium);
   $pref::LevelOfDetail = $Detail::Medium;
   updateShadows();
   updateHats();
   updateZoomLevel();
   updateBuildingProps();
}

// when the high effects detail button is selected
function HighDetailButton::buttonSelect()
{
   LowDetailButton.selected = false;
   MediumDetailButton.selected = false;
   HighDetailButton.selected = true;
   
   setDetailLevel($Detail::High);
   $pref::LevelOfDetail = $Detail::High;
   updateShadows();
   updateHats();
   updateZoomLevel();
   updateBuildingProps();
}

// when the low model texture button is selected
function LowModelButton::buttonSelect()
{
   LowModelButton.selected = true;
   HighModelButton.selected = false;
   
   setTextureModelMode($TextureManager::Low);
   $pref::TextureManager::ModelMode = $TextureManager::Low;
}

// when the high model texture button is selected
function HighModelButton::buttonSelect()
{
   LowModelButton.selected = false;
   HighModelButton.selected = true;
   
   setTextureModelMode($TextureManager::High);
   $pref::TextureManager::ModelMode = $TextureManager::High;
}

// when the low terrain texture button is selected
function LowTerrainButton::buttonSelect()
{
   LowTerrainButton.selected = true;
   HighTerrainButton.selected = false;
   
   setTextureTerrainMode($TextureManager::Low);
   $pref::TextureManager::TerrainMode = $TextureManager::Low;
}

// when the high terrain texture button is selected
function HighTerrainButton::buttonSelect()
{
   LowTerrainButton.selected = false;
   HighTerrainButton.selected = true;
   
   setTextureTerrainMode($TextureManager::High);
   $pref::TextureManager::TerrainMode = $TextureManager::High;
}

// when all of the options should be loaded
function GameOptionsGui::onWake(%this)
{
   // update the fullscreen mode
   $FullscreenMode = isFullScreen();
   if ($FullscreenMode == true)
   {
      FullscreenButton.selected = true;
      
      // if the game can only be rendered in fullscreen mode,
      // disable the full windowed mode option
      WindowedButton.selected = false;
   }
   else
   {
      FullscreenButton.selected = false;
      WindowedButton.selected = true;
   }
   
   // update level of detail for the effects
   if ($pref::LevelOfDetail == $Detail::Low)
   {
      LowDetailButton.selected = true;
      MediumDetailButton.selected = false;
      HighDetailButton.selected = false;
   }
   else if ($pref::LevelOfDetail == $Detail::Medium)
   {
      LowDetailButton.selected = false;
      MediumDetailButton.selected = true;
      HighDetailButton.selected = false;
   }
   else
   {
      LowDetailButton.selected = false;
      MediumDetailButton.selected = false;
      HighDetailButton.selected = true;
   }
   
   // update the level of detail for the models
   if ($pref::TextureManager::ModelMode == $TextureManager::Low)
   {
      LowModelButton.selected = true;
      HighModelButton.selected = false;
   }
   else
   {
      LowModelButton.selected = false;
      HighModelButton.selected = true;
   }
   
   // update the level of detail for the terrain
   if ($pref::TextureManager::TerrainMode == $TextureManager::Low)
   {
      LowTerrainButton.selected = true;
      HighTerrainButton.selected = false;
   }
   else
   {
      LowTerrainButton.selected = false;
      HighTerrainButton.selected = true;
   }

   // load the resolution
   $ScreenResolution = getRes();
   GameOptionsResolutionMenu.loadOptions();

   // initialize the option sliders
   $MusicVolume = $pref::Audio::channelVolume1;
   $SFXVolume = $pref::Audio::channelVolume2;
   $GammaCorrection = $pref::OpenGL::gammaCorrection;

   // music settings
   GameOptionsMusic.setValue($MusicVolume);

   // sound effects settings
   GameOptionsSFX.setValue($SFXVolume);

   // gamma settings
   //GameOptionsGammaCorrection.setValue($GammaCorrection);
}

function GameOptionsGui::onSleep(%this)
{
   // write out the control config into the rw/config.cs file
   ////moveMap.save( "./client/config.cs" );
}
